/**
 * @file CGInitializeLeaderboard.js
 * @author Frank Hamilton
 * @date 2024/2/27
 * @brief CGInitializeLeaderboard.js
 * @copyright Copyright (c) 2023, ByteDance Inc, All Rights Reserved
 */

const {BaseNode} = require('../Utils/BaseNode');
const {LeaderboardDataStore} = require('../../../Plugins/LeaderboardDataStore');

const Amaz = effect.Amaz;
const LBSDS = LeaderboardDataStore.instance;

class CGInitializeLeaderboard extends BaseNode {
  constructor() {
    super();
  }

  onInit() {
    LBSDS.setLeaderboardOrder(this.inputs[0]() === 'High' ? 0 : 1);
    this.initialSettings();
  }

  resetOnRecord(sys) {
    this.initialSettings();
  }

  initialSettings() {
    this.leaderboardRead = false;
  }

  setNext(index, func) {
    this.nexts[index] = func;
  }

  setInput(index, func) {
    this.inputs[index] = func;
  }

  onUpdate(sys, dt) {
    if (!LBSDS) return;

    if (LBSDS.leaderboardReady === true && this.leaderboardRead === false) {
      this.processLeaderboardInformation();
      this.leaderboardRead = true;
    }
  }

  processLeaderboardInformation() {
    if (LBSDS.leaderboard_Data) {
      if (LBSDS.hasScore === true) {
        this.outputs[1] = LBSDS.bestScore;
      } else {
        this.outputs[1] = -1;
      }

      this.outputs[2] = LBSDS.friends_rank;
      this.outputs[3] = LBSDS.national_rank;
      this.outputs[4] = LBSDS.global_rank;
    }

    if (this.nexts[0]) {
      this.nexts[0]();
    }
  }
}

exports.CGInitializeLeaderboard = CGInitializeLeaderboard;
