/**
 * @file CGGetUserProfile.js
 * @author Frank Hamilton
 * @date 2024/02/13
 * @brief CGGetUserProfile.js
 * @copyright Copyright (c) 2023, ByteDance Inc, All Rights Reserved
 */

const {BaseNode} = require('../Utils/BaseNode');
const {LeaderboardDataStore} = require('../../../Plugins/LeaderboardDataStore');

const Amaz = effect.Amaz;
const LBSDS = LeaderboardDataStore.instance;

class CGGetUserProfile extends BaseNode {
  constructor() {
    super();
  }

  resetOnRecord(sys) {
    this.initialSettings();
  }

  onInit() {
    this.initialSettings();
    this.outputs[1] = '';
    this.outputs[2] = this.releatedRes.get('00000000-0000-0000-0000-000000004007');
    this.outputs[3] = -1;
  }

  initialSettings() {
    this.leaderboardRead = false;
    this.friendsListRead = false;
    this.pulseTriggered = false;
    this.leaderboardFailure = false;

    if (this.releatedRes) {
      LBSDS.defaultIcon = this.releatedRes.get('00000000-0000-0000-0000-000000004007');
    }
  }

  setNext(index, func) {
    this.nexts[index] = func;
  }

  setInput(index, func) {
    this.inputs[index] = func;
  }

  onUpdate(sys, dt) {
    if (!LBSDS) return;

    if (this.friendsListRead === true && this.leaderboardRead === true) {
      if (this.pulseTriggered === false && this.nexts[0]) {
        this.nexts[0]();
        this.pulseTriggered = true;
      }
    }

    if (LBSDS.leaderboardReady === true && this.leaderboardRead === false) {
      if (LBSDS.userProfile_Data && LBSDS.userProfile_Data.nickname) {
        this.outputs[1] = LBSDS.userProfile_Data.nickname;
        LBSDS.getImage(LBSDS.userProfile_Data.avatar_path, this.imageCallback.bind(this));
      }
    }

    if (LBSDS && LBSDS.standardFriendsListReady === true && this.friendsListRead === false) {
      this.outputs[3] = LBSDS.standardFriendCount;
      this.friendsListRead = true;
    }
  }
  imageCallback(image) {
    if (!image) return;
    this.outputs[2] = image;
    this.leaderboardRead = true;
  }
}

exports.CGGetUserProfile = CGGetUserProfile;
